// BlobEllipsoid.h
// Definit la classe des blobs Ellipsoides (spheres deformables par une transformation lineaire)

#ifndef V3D_BLOBS_BLOB_ELLIPSOID_H_INCLUDED
#define V3D_BLOBS_BLOB_ELLIPSOID_H_INCLUDED

#include "BlobTransformable.h"


namespace V3D{

//////////////////////////////////////////////////////////////////////////////////////////
class BlobEllipsoid : public BlobTransformable
{
	typedef BlobTransformable parent;

// Le rayon est constant et de valeur 1,
// car ce rayon est integre au scale de la matrice de transformation

	BLOBTRANSFORMABLE_STD_OVERRIDES( BlobEllipsoid );

public:
	// Construction / Destruction
	BlobEllipsoid(float fCenterEnergy, const Vector3D& vcPos, float fInfluenceRange);
	BlobEllipsoid(float fCenterEnergy = 1.f);
	virtual ~BlobEllipsoid();

	virtual inline bool  EarlyRejectPoint(const Vector3D& vcPos) const;
	virtual inline float GetBaseShapeSqrDist(const Vector3D& pos) const;
	virtual inline void  ConvertBaseShapePosToGradient( Vector3D& vcOffs) const;


	virtual bool ComputeBlobBounds(Vector3D& vcBallMin, Vector3D& vcBallMax) const;

	// Calcule a partir de la boite definie par vcBoxMin et vcBoxMax, 
	// son sous-ensemble minimum contenant le blob.
	// Retourne true si cette boite minimum existe (volume non nul)
	// Pas redefinie encore, on garde celle par defaut definie par BlobBase
	//virtual bool ComputeMinEnclosingBoxAligned(Vector3D& vcMin, Vector3D& vcMax, const Vector3D& vcBoxMin, const Vector3D& vcBoxMax) const;


protected:

	void AddLineEnergy(float* pafCurEnergy, int32 nSteps, const Vector3D& vcFirst, const Vector3D& vcStep) const;

	virtual void EnergyBaseShapeAddAtRectangle ( float* pafAddEnergies,    // Tableau des valeurs energetiques de la grille
										 const Vector3D& vcRectStart,  // Origine du rectangle
										 const Vector3D& vcRectAxisX,  // Axe X du rectangle (sert d'unite de separation entre deux calculs d'energie)
										 const Vector3D& vcRectAxisY,  // Axe Y du rectangle (sert d'unite de separation entre deux calculs d'energie)
                                         int32 nLinesCount,                    // Nombre de subdivisions en Y dans le rectangle
										 int32 nLineLength,                    // Nombre de subdivisions en X dans le rectangle
										 int32 nSizeX                          // Nombre de subdivisions en X dans la grille
												) const ;

protected:
	

private:

	// Defini dans le fichier .cpp
	template <int EVALTYPE>
		void AddLineEnergyConfig(float* pafCurEnergy, int32 nSteps, const Vector3D& vcFirst, const Vector3D& vcStep) const;

};

//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////


inline float BlobEllipsoid::GetBaseShapeSqrDist(const Vector3D& pos) const 
{ 
	return float(pos.x*pos.x + pos.y*pos.y + pos.z*pos.z);
}
						/////////////////////////////

inline void  BlobEllipsoid::ConvertBaseShapePosToGradient( Vector3D& /* vcOffs */) const
{
	// Le gradient reste justement le vecteur position
}

						/////////////////////////////

inline bool BlobEllipsoid::EarlyRejectPoint(const Vector3D& pos) const
{
	// return ( pos.x < m_vcBoundMin.x || pos.y < m_vcBoundMin.y || pos.z < m_vcBoundMin.z || 
	//		     pos.x > m_vcBoundMax.x || pos.y > m_vcBoundMax.y || pos.z > m_vcBoundMax.z );

	// Optimisation : un seul saut conditionnel
	const Vector3D& vcBoundsMin = GetBlobBoundsMin();
	const Vector3D& vcBoundsMax = GetBlobBoundsMax();
	return  ( ( FastFloatGetSign(float(pos.x - vcBoundsMin.x)) | 
			    FastFloatGetSign(float(pos.y - vcBoundsMin.y)) | 
			    FastFloatGetSign(float(pos.z - vcBoundsMin.z)) | 
			    FastFloatGetSign(float(vcBoundsMax.x - pos.x)) | 
			    FastFloatGetSign(float(vcBoundsMax.y - pos.y)) | 
			    FastFloatGetSign(float(vcBoundsMax.z - pos.z))) != 0);
}

						/////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////


} // namespace



#endif	// #ifndef V3D_BLOBS_BLOB_ELLIPSOID_H_INCLUDED

